<?php
// Caminho para o arquivo de log
$logFile = '/home/digupdog/public_html/update_user_id.log';

// Função para adicionar entradas no log
function logMessage($message) {
    global $logFile;
    file_put_contents($logFile, date('Y-m-d H:i:s') . " - " . $message . "\n", FILE_APPEND);
}

// Configurações de conexão com o banco de dados
$host = 'localhost';
$db = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

try {
    // Estabelece conexão com o banco de dados
    $pdo = new PDO($dsn, $user, $pass, $options);
    logMessage("Conexão com o banco de dados estabelecida.");

    // Verifica se a coluna 'user_id' já existe
    $result = $pdo->query("SHOW COLUMNS FROM feedsplus LIKE 'user_id'");
    $columnExists = $result->rowCount() > 0;
    logMessage("Verificação da coluna 'user_id': " . ($columnExists ? "Existe" : "Não existe"));

    if (!$columnExists) {
        // Adiciona a coluna 'user_id' se não existir
        try {
            $sql_add_column = "ALTER TABLE feedsplus ADD COLUMN user_id INT NULL";
            $pdo->exec($sql_add_column);
            logMessage("Coluna 'user_id' adicionada com sucesso à tabela 'feedsplus'.");
        } catch (PDOException $e) {
            logMessage("Erro ao adicionar a coluna 'user_id': " . $e->getMessage());
            exit; // Sai do script se não conseguir adicionar a coluna
        }
    } else {
        logMessage("Coluna 'user_id' já existe na tabela 'feedsplus'.");
    }

    // Verifica quantos registros precisam ser atualizados
    try {
        $totalRecords = $pdo->query("SELECT COUNT(*) FROM feedsplus WHERE user_id IS NULL")->fetchColumn();
        logMessage("Total de registros que precisam ser processados: $totalRecords.");
    } catch (PDOException $e) {
        logMessage("Erro ao contar registros: " . $e->getMessage());
        exit;
    }

    if ($totalRecords > 0) {
        // Processamento em lotes
        $batchSize = 500;  // Tamanho do lote
        $offset = 0;
        $totalProcessed = 0;

        do {
            try {
                logMessage("Iniciando processamento do lote. Offset: $offset, Batch size: $batchSize");

                // Inicia uma transação para o lote atual
                $pdo->beginTransaction();

                // Atualiza um lote de registros
                $sql_update_batch = "UPDATE feedsplus SET user_id = NULL WHERE user_id IS NULL LIMIT $batchSize OFFSET $offset";
                $affectedRows = $pdo->exec($sql_update_batch);

                logMessage("Consulta executada. Registros afetados: $affectedRows.");

                // Confirma a transação
                $pdo->commit();
                logMessage("Transação confirmada para o lote. Offset: $offset");

                $totalProcessed += $affectedRows;
                $offset += $batchSize;

                logMessage("Total processado até agora: $totalProcessed de $totalRecords.");

                if ($affectedRows == 0) {
                    logMessage("Nenhum registro afetado no lote atual, encerrando o processamento.");
                    break;
                }

            } catch (PDOException $e) {
                logMessage("Erro ao atualizar registros: " . $e->getMessage());
                $pdo->rollBack(); // Faz rollback se houver um erro
                exit; // Sai do script se não conseguir atualizar
            }

            // Dorme um pouco para reduzir a carga no banco de dados (opcional)
            usleep(200000); // 200 milissegundos (0.2 segundo)

        } while ($affectedRows > 0);

        // Adiciona o índice na coluna 'user_id' após a atualização
        if ($totalProcessed > 0) {
            try {
                $sql_add_index = "ALTER TABLE feedsplus ADD INDEX idx_user_id (user_id)";
                $pdo->exec($sql_add_index);
                logMessage("Índice 'idx_user_id' adicionado com sucesso à coluna 'user_id'.");
            } catch (PDOException $e) {
                logMessage("Erro ao adicionar o índice 'idx_user_id': " . $e->getMessage());
            }
        }
    } else {
        logMessage("Nenhum registro encontrado para atualizar.");
    }

} catch (PDOException $e) {
    // Em caso de erro, registra a mensagem de erro
    logMessage("Erro ao modificar a tabela: " . $e->getMessage());
}
?>
